/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal;

import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.ds.*;
import cnrg.itx.datax.*;

/** This interface defines the methods that applications need to implement in order to use Signaling services.
 */
public interface SignalingObserver {

	/**
	 * This method informs the application that a peer application's invitation
	 * has been received.
	 * 
	 * @param ise is the InviteSignalEvent that contains all the information about
	 * the caller application.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.InviteSignalEvent
	 */
	public void onInvite(InviteSignalEvent ise);

	/**
	 * This method informs the application that a peer application has sent
	 * a confirmation and the call setup is complete.
	 * 
	 * @param  sc is the SignalConnection the Application should use for data exchange.
	 *         The connection within SignalConnection may be instantiated by the application.
	 * 
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.client.SignalConnection
	 */
	public void onStartCall(SignalConnection sc);
	
	/**
	 * This method informs the application that it should abort the call it was
	 * waiting for.
	 * 
	 * @param ase is the AbortSignalEvent describing the reason for the abort and
	 * which indicates the user that aborted the invite and returns the connection object
	 * the onInvite call gave signaling, if any.
	 * @return  void
	 */
	public void onAbortCall(AbortSignalEvent ase);
	
	/**
	 * This method informs the application that a peer application has hung up.
	 * 
	 * @param hse is the HangupSignalEvent that contains all the information about
	 * the application that has hung up.
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.HangupSignalEvent
	 */
	public void onHangup(HangupSignalEvent hse);
	
	/**
	 * This method informs the application that a DTMF has been received.
	 * 
	 * @param dtmfse is the DTMFSignalEvent that contains the tone(s).
	 * @return  void
	 * 
	 * @see cnrg.itx.signal.SignalEvent.DTMFSignalEvent
	 */
	public void onDTMF(DTMFSignalEvent dtmfse);
}
	
	